START TRANSACTION;

DROP TABLE IF EXISTS `appscheduler_vouchers`;
CREATE TABLE IF NOT EXISTS `appscheduler_vouchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(100) DEFAULT NULL,
  `used_count` int(10) unsigned DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(14,2) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `condition` enum('period','made','both') DEFAULT NULL,
  `apply_on` enum('room','extra','both') DEFAULT NULL,
  `is_active` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoVoucherListDesc', 'backend', 'Infobox / List of coupons', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'List of coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoVoucherListTitle', 'backend', 'Infobox / List of coupons', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'List of coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblVoucherCode', 'backend', 'Label / Coupon code', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Coupon code', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblVoucherCodeExist', 'backend', 'Coupon code is already used.', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Coupon code is already used', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'voucher_types_ARRAY_amount', 'arrays', 'voucher_types_ARRAY_amount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Amount', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'voucher_types_ARRAY_percent', 'arrays', 'voucher_types_ARRAY_percent', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Percent', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblVoucherAppliedOn', 'backend', 'Label / Applied on', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Applied on', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblVoucherUsage', 'backend', 'Label / Usage', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Usage', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'dash_manage_coupons', 'backend', 'Dash / Manage Coupons', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Manage Coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoVoucherListsDesc', 'backend', 'Infobox / List of coupons', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'List of coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'menuCouponsDiscounts', 'backend', 'Menu / Coupons & Discounts', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Vouchers/Coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'tabCoupons', 'backend', 'Tab / Coupons', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Coupons', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Discount', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDiscountName', 'backend', 'Label / Discount name', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Discount name', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDiscountOptions', 'backend', 'Label / Options', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Options', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblValidityFrom', 'backend', 'Coupon Start date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Coupon Start date', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblValidityTo', 'backend', 'Coupon Expiry date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Coupon Expiry date', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblExportSelected', 'backend', 'Export selected', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Export selected', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnAddCoupon', 'backend', 'Button / Add coupon', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Add coupon', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDateFrom', 'backend', 'Label / Coupon Start date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Label / Coupon Start date', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDateTo', 'backend', 'Label / Coupon Expiry date', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Label / Coupon Expiry date', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'lblDiscountType', 'backend', 'Label / Discount Type', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Label / Discount Type', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'btnClose', 'backend', 'Label / Close', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Close', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoAddVoucherTitle', 'backend', 'Add coupon', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Add coupon', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'infoUpdateVoucherTitle', 'backend', 'Infobox / Update coupon code', 'script', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '1', 'title', 'Update coupon code', 'script');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers', 'backend', 'pjVouchers', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Vouchers Menu', 'plugin');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionCreate', 'backend', 'pjVouchers_pjActionCreate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Add vouchers', 'plugin');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionDeleteVoucher', 'backend', 'pjVouchers_pjActionDeleteVoucher', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single voucher', 'plugin');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionDeleteVoucherBulk', 'backend', 'pjVouchers_pjActionDeleteVoucherBulk', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete multiple vouchers', 'plugin');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionExportVoucher', 'backend', 'pjVouchers_pjActionExportVoucher', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Export vouchers', 'plugin');
 
INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionUpdate', 'backend', 'pjVouchers_pjActionUpdate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Edit vouchers', 'plugin');
 
COMMIT;